// Jolt3D_Main.cpp : Defines the entry point for the application.
//
#include "JOLT3D.H"

#define MAX_X      100
#define MAX_Z      100

CAMERA             cam;
SHAPE              cube;
bool               field[MAX_X][MAX_Z];
bool               field_new[MAX_X][MAX_Z];
UINT               steps;
UINT               maxsteps;

// Load here all the Jolt3D Resources & Engine too.
void Load_J3D_Resources()
{
     jStart_Engine(Engine);
}

// Release here all the Jolt3D resources & Engine too.
void Release_J3D_Resources()
{
     jRelease_Shape(&cube);
     jRelease_Engine();
}

void One_Time_Initialization()
{
     // cam
     jSet_Camera_From_Degrees(&cam,jVec3(-3,2,-3),FOV_1,45.f,-5.f,200.f);
     
     jCreate_Box(&cube,0.8f,0.8f,0.8f);
     steps=0;
     
     UINT i,j;
     for (i=0;i<MAX_X;i++)
       for (j=0;j<MAX_Z;j++)
         if (jGet_Random_Int(0,5)>3) field[i][j]=true;
     
     field[53][50] = true;
     field[52][50] = true;
     field[51][50] = true;
     field[51][51] = true;
     field[52][52] = true;

     jSet_Fog_Linear(jColor(255,220,180,220),10.f,50.f);
     jEnable_Fog(true);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
// TODO: Place code here.

// Window Stuff
Engine.hInstance=hInstance;
Engine.EscapeKey=KB_ESCAPE;
// Desired Resolution
Engine.Res.AppWidth=1024;
Engine.Res.AppHeight=768;
Engine.Res.WinWidth=800;
Engine.Res.WinHeight=600;
Engine.Res.Bpp=32;
Engine.Res.Depth=32;
// Refresh Rate: You can set REFRESH_MINIMUM, REFRESH_MAXIMUM or a real number! (if not supported, maximum used)
Engine.Res.RefreshRate=REFRESH_MAXIMUM;
// Hardwarealse
Engine.HAL=true;
Engine.Use_HW_VtxProcess=true;
// Rendering
Engine.Windowed=true;
Engine.VSync=true;
Engine.Antialiasing_Samples=FSAA_NONE;

if (!Load_DLL(""))
  return -1;
Load_J3D_Resources();
One_Time_Initialization();
jRun_Engine();
Release_J3D_Resources();
Free_DLL();
return 0;
}

// Main Rendering! (Dont use it, is exist ONLY to Mirror a current Scene for 'Mirroring')
// Allowable Functions (for good results) is: Render_Mirror_Quad() and Set_View_Port()
// (Of course there is no need to write the 2 functions above if you're NOT using mirrors 
// or viewport changes)
void Render()
{
jClear(CLEAR_TARGET_ZBUFFER,jColor(255,220,180,220));
jBegin_Scene();

Engine.RenderScene();

jEnd_Scene();
}

// Scene Rendering! (write HERE your 'game' including objects drawing etc.)
void RenderScene()
{
// Start Code //

   // CAM
   jView_Camera(&cam);
   jSet_View_By_Mouse(&cam,0.3f,true,true);
   jMove_Camera_By_Keys(&cam,15.f,true);
   jEnable_Lighting(true);
   jSet_Ambient_Color(jColor(255,255,255,255));
   
   if (jKey_BtDown(KB_1,true)) maxsteps=1;
   if (jKey_BtDown(KB_2,true)) maxsteps=2;
   if (jKey_BtDown(KB_3,true)) maxsteps=3;
   if (jKey_BtDown(KB_4,true)) maxsteps=4;
   if (jKey_BtDown(KB_5,true)) maxsteps=5;
   if (jKey_BtDown(KB_0,true)) maxsteps=0;
   
   UINT i,j;
   steps ++;
   
   if (steps >= maxsteps)
   {
     steps = 0;
     for (i=0;i<MAX_X;i++)
       for (j=0;j<MAX_Z;j++)
       {
         // CALCULATING PART
         UINT n=0;
         if (i>0) {     // 3 fields on the left
           if (field[i-1][j]==true) n++;
           if (j>0)
             if (field[i-1][j-1]==true) n++;
           if (j<MAX_Z)
             if (field[i-1][j+1]==true) n++;
         }
         if (i<MAX_X) { // 3 fields on the right
           if (field[i+1][j]==true) n++;
           if (j>0)
             if (field[i+1][j-1]==true) n++;
           if (j<MAX_Z)
             if (field[i+1][j+1]==true) n++;
         }
         // above and under
         if (j>0)
           if (field[i][j-1]==true) n++;
         if (j<MAX_Z)
           if (field[i][j+1]==true) n++;
       
         if (n<2)  field_new[i][j]=false;
         if (n==2) field_new[i][j]=field[i][j];
         if (n==3) field_new[i][j]=true;
         if (n>3)  field_new[i][j]=false;
       }
   
    for(i=0;i<MAX_X;i++)
      for(j=0;j<MAX_Z;j++)
        field[i][j]=field_new[i][j];
    } 
    
    
   // DRAWING PART
   for (i=0;i<MAX_X;i++)
     for (j=0;j<MAX_Z;j++)
     {
       FRUSTUM  frustum;
       float    height;
       MATERIAL mat;
       
       if (field_new[i][j] == true) {
         height=0.5f;
         mat = jSet_Material_Typical(MTRL_LIGHTRED,false);
         jSet_Fill_Mode(FILL_SOLID);
       }
       else {
         height=0;
         mat = jSet_Material_Typical(MTRL_LIGHTBLUE,false);
         jSet_Fill_Mode(FILL_POINT);
       }
       jSet_Texture_Null(0);
       jSet_Texture_Null(1);
       jTranslate((float)(i-49.9f),height,(float)(j-49.9f));
       jTransform();
       jGet_Frustum(&frustum);
       if (jIs_BBox_Inside_Screen(frustum,jGet_Transform(),cube.BoundingBox))
         jDraw_Shape(&cube,mat,255);
     }
   
}

// WINDOW SYSTEM ////////////////////////////////////////////////////////////////////////////////////
// THE 'BODIES' BELOW IS THE GRAPHICS THAT YOUR SYSTEM WILL USE FOR WINDOW CONTROLS
// IF YOU DONT LIKE THE STANDARD ONES THAT DEFINED, CHANGE THEM

// Write your 'body' source for Windows!
void Windows_Body(int Win,bool Selected,FONT Font,char Title[260],int Tx1,int Ty1,int Tx2,int Ty2,int Bx1,int By1,int Bx2,int By2,int TextX,int TextY)
{
Draw_Classic_Window(Win,Selected,Tx1,Ty1,Tx2,Ty2,Bx1,By1,Bx2,By2,TextX,TextY);
Draw_Standard_Windows(Win,Tx1,Ty1,Tx2,Ty2,Bx1,By1,Bx2,By2,TextX,TextY);
}

// Write your 'body' source for Buttons!
void Buttons_Body(int Button,bool Pressed,FONT Font,char Title[260],int Bx1,int By1,int Bx2,int By2,int TextX,int TextY)
{
Draw_Classic_Button(Button,Pressed,Bx1,By1,Bx2,By2,TextX,TextY);
Draw_Standard_Buttons(Button,Pressed,Bx1,By1,Bx2,By2,TextX,TextY);
}

// Write your 'body' source for CheckBoxes!
void CheckBox_Body(int CheckBox,bool Checked,FONT Font,char Text[260],int Cx1,int Cy1,int Cx2,int Cy2,int TextX,int TextY)
{
Draw_Classic_CheckBox(CheckBox,Checked,Cx1,Cy1,Cx2,Cy2,TextX,TextY);
}

// Write your 'body' source for ScrollBars!
void ScrollBar_Body(int ScrollBar,int Type,int Scx1,int Scy1,int Scx2,int Scy2,int Cbx1,int Cby1,int Cbx2,int Cby2)
{
Draw_Classic_ScrollBar(ScrollBar,Scx1,Scy1,Scx2,Scy2,Cbx1,Cby1,Cbx2,Cby2);
}

// Write your 'body' source for EditBoxes!
void EditBox_Body(int EditBox,bool Edited,FONT Font,char Text[260],int Ex1,int Ey1,int Ex2,int Ey2,int Lx,int Ly1,int Ly2,int TextX,int TextY)
{
Draw_Classic_EditBox(EditBox,Ex1,Ey1,Ex2,Ey2,Lx,Ly1,Ly2,TextX,TextY);
}

// Write your 'body' source for DropDowns!
void DropDown_Body(int DropDown,UINT Style,int Selected,bool Dropped,FONT Font,int Selx1,int Sely1,int Selx2,int Sely2,int Dbx1,int Dby1,int Dbx2,int Dby2,int Enx1,int Eny1,int Enx2,int Eny2,int TextX,int TextY,char Title[260],char SelectedEntry[260])
{
Draw_Classic_DropDown(DropDown,Style,Selx1,Sely1,Selx2,Sely2,Dbx1,Dby1,Dbx2,Dby2,Enx1,Eny1,Enx2,Eny2,TextX,TextY);
}

// Write your 'body' source for HighLighted Selection of DropDowns!
void HighLight_DropDown(int DropDown,int x1,int y1,int x2,int y2,int TextX,int TextY,FONT *Font,char Text[260])
{
Draw_Classic_HighLight_DropDown(DropDown,x1,y1,x2,y2,TextX,TextY,Text);
}

// Write your 'body' source for GroupBoxes!
void GroupBox_Body(int GroupBox,FONT Font,char Title[260],int Gx1,int Gy1,int Gx2,int Gy2,int TextX,int TextY,int TextWidth)
{
Draw_Classic_GroupBox(GroupBox,Gx1,Gy1,Gx2,Gy2,TextX,TextY,TextWidth);
}

// Write your 'body' source for ANY Graphics that will be drawn ABOVE the Window System!
void Draw_Above_Windows()
{
}

// MULTIPLAYER MESSAGE HANDLING ///////////////////////////////////////////////////////////////////////

// a similar structure that contains all players in a session. The only important thing is
// that you MUST limit to 'MAX_PLAYERS', otherwise you get memory bugs...
struct _players
{
bool Exist[MAX_PLAYERS];
char Name[ MAX_PLAYERS ][260];

// send your specific
};
_players players;

// This is the Message Handler for multiplayer games for Jolt3D! All the messages from all peers
// of internet are send here for handling.
// The function is called internally and Asynchronously! DONT draw objects here or any DirectX
// related objects, cause bugs will come..Instead, give flags to do actions in 'RenderScene()' function.
void Message_Handling(BYTE MessageType, char Message[512], DPNID SenderID, DWORD SenderPos)
{
// contains the local player position
DWORD LocalPos;
PLAYERS pp;

// Resolve type of message..
switch(MessageType)
{
case TYPE_MESSAGE:

// The 'Message' contains the string that the player with 'SenderID' has send you.

break;
// A Player (The Host or a peer) has created/joined the session...Create him now!
case TYPE_CREATE_PLAYER:
// If the player that now created is DIFFERENT from us (Local), we must
// inform him with OUR player currently informations...(etc. Position perhaps)
// This is a critical point; the new players MUST know what infos we have!
// (This is a step that ALL -already-created- players must do)
if (SenderID != jGet_Local_Player_ID())
  LocalPos=jGet_Player_Pos_From_ID( jGet_Local_Player_ID() );

// create (or copy) here the player in your own structure...

// get the basic Jolt3D! players info...(theyre not enough for a complex game of course...)
pp=jGet_Players_Info();
// ...copy them to your real one structure! This sample just copy ONLY the name; You can copy
// them all if you want, and also set HERE & NOW the desired (starting up) values for this player.
// The 'players' structure is the REAL one player for this game; The 'pp' is the internal -give-n-take-
// structure that use ALL peers through internet...
players.Exist[SenderPos]=true;
strcpy(players.Name[SenderPos],pp.Name[SenderPos]);
break;
// A PLAYER (PEER) HAS REMOVED FROM SESSION...DESTROY HIM NOW!
case TYPE_DESTROY_PLAYER:

// destroy here the player in your own structure...
players.Exist[SenderPos]=false;
break;
}

}
